% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_power.R
\name{prop_power}
\alias{prop_power}
\title{Power and sample size for 2 proportions}
\usage{
prop_power(n, n1, n2, p1, p2, fraction = 0.5, alpha = 0.05,
  power = NULL, alternative = c("two.sided", "one.sided"), odds.ratio,
  percent.reduction, ...)
}
\arguments{
\item{n}{total sample size.}

\item{n1}{sample size in group 1.}

\item{n2}{sample size in group 2.}

\item{p1}{group 1 proportion.}

\item{p2}{group 2 proportion.}

\item{fraction}{fraction of total observations that are in group 1.}

\item{alpha}{significance level/type 1 error rate.}

\item{power}{desired power, between 0 and 1.}

\item{alternative}{alternative hypothesis, one- or two-sided test.}

\item{odds.ratio}{odds ratio comparing p2 to p2.}

\item{percent.reduction}{percent reduction of p1 to p2.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "prop_power" containing the following components:

\item{n}{the total sample size}
\item{n1}{the sample size in group 1}
\item{n2}{the sample size in group 2}
\item{p1}{the proportion in group 1}
\item{p2}{the proportion in group 2}
\item{power}{calculated or desired power}
\item{sig.level}{level of significance}
}
\description{
Calculate power and sample size for comparison of 2 proportions for both balanced and unbalanced designs.
}
\details{
Power calculations are done using the methods described in `stats::power.prop.test`,
   `Hmisc::bsamsize`, and `Hmisc::bpower`.
}
\examples{
prop_power(n = 220, p1 = 0.35, p2 = 0.2)
prop_power(p1 = 0.35, p2 = 0.2, fraction = 2/3, power = 0.85)
prop_power(p1 = 0.35, n = 220, percent.reduction = 42.857)
prop_power(p1 = 0.35, n = 220, odds.ratio = 0.4642857)

}
\seealso{
[stats::power.prop.test], [Hmisc::bsamsize], [Hmisc:bpower]
}
