% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{riskdiff.table}
\alias{riskdiff.table}
\title{Risk difference}
\usage{
\method{riskdiff}{table}(df, conf.level = 0.95, rev = c("neither",
  "rows", "columns", "both"), ...)
}
\arguments{
\item{df}{a 2 x 2 frequency table.}

\item{conf.level}{confidence level for confidence interval, default is 0.95.}

\item{rev}{reverse order of cells. Options are "row", "columns", "both", and "neither" (default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "rdiff" containing the following components:

\item{rd}{risk difference}
\item{conf.level}{specified confidence level}
\item{ci}{calculated confidence interval}
\item{p1}{proportion one}
\item{p2}{proportion two}
\item{tab}{2x2 table using for calculating risk difference}
}
\description{
Calculate risk difference and 95 percent confidence interval using Wald method.
}
\examples{
trial <- data.frame(
  disease = c(rep("yes", 2), rep("no", 2)),
  treatment = c(rep(c("estrogen", "placebo"), 2)),
  count = c(751, 623, 7755, 7479))

xtabs(count ~ treatment + disease, data = trial) \%>\% riskdiff()
}
