% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catmap.R
\name{catmap}
\alias{catmap}
\title{catmap: Case-Control and TDT Meta-Analysis Package}
\usage{
catmap(dataset, ci = 0.95, printout = FALSE)
}
\arguments{
\item{dataset}{A \code{data.frame}, \code{matrix}, or file location.
The input should have the following column names: name, study, t, nt,
caserisk, controlrisk, casenotrisk, controlnotrisk. For a file location,
provide the data in a tab-delimited format. Note that the header must have
these exact columns and all cells in the table must have an entry, even
if the entry is 0 or NA. See \code{\link{catmapdata}} for an example.}

\item{ci}{A numeric value. The confidence level for confidence intervals;
0 < ci < 1.}

\item{printout}{A boolean. Toggles whether a text file of the models
and Q statistic results should get saved to the working directory.}
}
\description{
This package conducts fixed-effects (with inverse variance weighting) and
 random-effects [DerSimonian and Laird (1986)] meta-analyses of case-control
 or family-based (TDT) genetic data. In addition, catmap performs
 meta-analyses which combine these two types of study designs. Specifically,
 this package implements a fixed-effects model [Kazeem and Farrall (2005)]
 and a random-effects model [Nicodemus (2008)] for combined studies.
}
\details{
Use the output of the \code{catmap} function to generate figures using
 secondary functions. These secondary functions produce output as either
 a txt file, a pdf plot, or both.

A standard forest plot is available via \code{\link{catmap.forest}}.
 A funnel plot is available via \code{\link{catmap.funnel}}. However,
 no formal test of publication bias is available (see
 [Ioannidis and Trikalinos (2007)]).

In addition, cumulative meta-analyses over time (\code{\link{catmap.cumulative}})
 and leave-one-out sensitivity analyses (\code{\link{catmap.sense}}) are
 available for the fixed-effects estimates and random-effects estimates.
}
\examples{
data(catmapdata)
catmapobject <- catmap(catmapdata, 0.95, TRUE)
}
\seealso{
\code{\link{catmap}}, \code{\link{catmap.forest}},
 \code{\link{catmap.sense}}, \code{\link{catmap.cumulative}},
 \code{\link{catmap.funnel}}
}
\author{
Algorithm designed and implemented by Kristin K. Nicodemus.
 Code modified and updated by Thom Quinn.
}
