% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate.tamat}
\alias{evaluate.tamat}
\title{Evaluate adjacency matrix estimation}
\usage{
\method{evaluate}{tamat}(est, true, metrics, ...)
}
\arguments{
\item{est}{Estimated adjacency matrix/matrices.}

\item{true}{True adjacency matrix/matrices.}

\item{metrics}{List of metrics, see details.}

\item{...}{Further arguments that depend on input type.  Currently only \code{list.out} is allowed, and
only if the first argument is a matrix (see details under Value).}
}
\value{
A data.frame with one column for each computed metric and one row per evaluated
matrix pair. Adjacency metrics are prefixed with "adj_", orientation metrics are prefixed
with "dir_", other metrics do not get a prefix. If the first argument is a matrix, \code{list.out = TRUE}
can be used to change the return object to a list instead. This list will contain three lists, where
adjacency, orientation and other metrics are reported, respectively.
}
\description{
Applies several different metrics to evaluate difference between
estimated and true adjacency matrices. Intended to be used to evaluate
performance of causal discovery algorithms.
}
\details{
Two options for input are available: Either \code{est} and \code{true}
can be two adjacency matrices, or they can be two arrays of adjacency matrices.
The arrays should have shape \eqn{n * p * p} where n is the number of of matrices,
and p is the number of nodes/variables.

The metrics should be given as a list with slots \code{$adj}, \code{$dir} and
\code{$other}. Metrics under \code{$adj} are applied to the adjacency confusion
matrix, while metrics under \code{$dir} are applied to the conditional orientation
confusion matrix (see \link{confusion}). Metrics under \code{$other} are applied
without computing confusion matrices first.

Available metrics to be used with confusion matrices are \link{precision}, \link{recall},
\link{specificity}, \link{FOR}, \link{FDR}, \link{NPV}, \link{F1} and \link{G1}. The user
can supply custom metrics as well: They need to have the confusion matrix as their first
argument and should return a numeric.

Available metrics to be used as "other" is: \link{shd}. The user
can supply custom metrics as well: They need to have arguments \code{est_amat} and \code{true_amat},
where the former is the estimated adjacency matrix and the latter is the true adjacency matrix. The
metrics should return a numeric.
}
