% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translation-modules.R
\name{create_effect_vector}
\alias{create_effect_vector}
\title{Translate target effect to vector of response variables}
\usage{
create_effect_vector(causal_model, effect)
}
\arguments{
\item{causal_model}{An object of class "causalmodel" as produced by \link{create_causalmodel}}

\item{effect}{Effect list, as returned by \link{parse_effect}}
}
\value{
A list with the target effect in terms of qs
}
\description{
Translate target effect to vector of response variables
}
\examples{
graph <- initialize_graph(graph_from_literal(Z -+ X, X -+ Y, Ul -+ Z, Ur -+ X, Ur -+ Y))
constraints <- "X(Z = 1) >= X(Z = 0)"
effectt = "p{Y(X = 1) = 1} - p{Y(X = 0) = 1}"
p.vals <- expand.grid(Z = 0:1, X = 0:1, Y = 0:1)
prob.form <- list(out = c("X", "Y"), cond = "Z")
effect <- parse_effect(effectt)
ivmod <- create_causalmodel(graph, respvars = NULL, p.vals = p.vals, prob.form = prob.form, 
         constraints = constraints)
var.eff <- create_effect_vector(ivmod, effect)
}
