% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active-transportation.R
\name{active_transport3_fun}
\alias{active_transport3_fun}
\title{Daily active transportation (2015-2018)}
\usage{
active_transport3_fun(PAYDVTTR, PAADVTRV)
}
\arguments{
\item{PAYDVTTR}{number of minutes of active transportation in a week 
for 12-17 years old.}

\item{PAADVTRV}{number of minutes of active transportation in a week 
for 18+ years old.}
}
\value{
Continuous variable for active transportation (active_transport)
}
\description{
This function creates a derived variable for daily time spent 
traveling in active ways. This includes walking and biking. This function is 
used for CCHS 2015-2018.
}
\examples{
# Using active_transport3_fun() to determine daily time spent 
# traveling in active ways values across CCHS 2015-2018.

# active_transport3_fun() is specified in variable_details.csv along with the CCHS
# variables and cycles included.

# To transform active_transport across cycles, use rec_with_table() for each
# CCHS cycle and specify active_transport, along with each activity variable.
# Then by using merge_rec_data(), you can combine active_transport across
# cycles

library(cchsflow)
active_transport2015_2016 <- rec_with_table(
  cchs2015_2016_p, c(
    "PAYDVTTR", "PAADVTRV","active_transport"
  )
)

head(active_transport2015_2016)

active_transport2017_2018 <- rec_with_table(
  cchs2017_2018_p, c(
    "PAYDVTTR", "PAADVTRV","active_transport"
  )
)

tail(active_transport2017_2018)

combined_active_transport <- suppressWarnings(merge_rec_data(
 active_transport2015_2016, active_transport2017_2018))

head(combined_active_transport)
tail(combined_active_transport)
}
