% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtm.R
\name{fRTM}
\alias{fRTM}
\title{Forward implementation of coupled Radiative Transfer Models.}
\usage{
fRTM(fm = rho + tau ~ prospect5 + foursail, pars = NULL,
  wl = 400:2500)
}
\arguments{
\item{fm}{A formula specifying which rtm to run}

\item{pars}{a list of _named_ parameter vectors for all models.
The parameter list for a model call as rho ~ prospect + foursail
therefore contains two named vectors the first with parameters for
prospect and the second with parameters for foursail 
if left empty default parameters are generated}

\item{wl}{wavelengths (in nm) add only if
certain wavelengths are required as output.
Input is expected to integers between 400 and 2500, or will 
be forced to be an integer. Integers outside the 400:2500 range
will not be returned.}
}
\value{
spectra matrix with reflectance (and transmission,
depending on the formula inputs). 
See seperate model helpfiles for details.
}
\description{
Forward implementation of coupled Radiative Transfer Models.
}
\examples{
## setup graphics for plots 
oldpar<-par()
par(mfrow=c(3,2))

## get reflectance for a leaf 
ref <- fRTM(rho~prospect5)
plot(ref,main="Prospect 5")
     
## get reflectance and transmission for a leaf 
reftrans <- fRTM(rho+tau~prospect5)
plot(reftrans,main="Prospect 5")
     
## get reflectance for a single layered canopy 
ref <- fRTM(rho~prospect5+foursail)
plot(ref,main="Prospect 5 + 4SAIL")

## get reflectance for a 2 layered canopy with two leaf types 
ref <- fRTM(rho~prospectd+prospect5+foursail2)
plot(ref,main="Prospect D + Prospect 5  + 4SAIL2")

## edit the parameters: sparse vegatation LAI 
parlist<- list(prospect5=NULL,prospectd=NULL,foursail2=c(LAI=0.05))

## update reflectance
ref <- fRTM(rho~prospect5+prospectd+foursail2,parlist)
plot(ref,main="LAI=0.05")

## change leaf area index to dense vegetation
parlist$foursail2["LAI"]<-8.5

## update reflectance
ref <- fRTM(rho~prospect5+prospectd+foursail2,parlist)
plot(ref,main="LAI=8.5")

par(oldpar)   
}
