% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prospect.R
\name{prospect5}
\alias{prospect5}
\title{PROSPECT model version 5 and 5B}
\usage{
prospect5(param)
}
\arguments{
\item{param}{A named vector of PROSPECT parameters (note: program ignores case):

 \itemize{
\item [1] = leaf structure parameter (N)
\item [2] = chlorophyll a+b content in ug/cm2 (Cab)
\item [3] = carotenoids content in ug/cm2 (Car)
\item [4] = brown pigments content in arbitrary units (Cbrown)
\item [5] = equivalent water thickness in g/cm2  (Cw)
\item [6] = leaf dry matter content in g/cm2 - lma - (Cm)
}}
}
\value{
spectra matrix with leaf reflectance and transmission 
for wavelengths 400 to 2500nm:
 \itemize{
\item [1] = leaf reflectance (rho)
\item [2] = leaf transmission (tau)
}
}
\description{
The PROSPECT5(b) leaf reflectance model. The model was implemented based on
Jacquemoud and Ustin (2019), and is further described in detail in Feret et al (2008).
PROSPECT models use the plate models developed in 
Allen (1969) and Stokes (1862). Set Cbrown to 0 for prospect version 5.
}
\references{
Jacquemoud, S., and Ustin, S. (2019). Leaf optical properties. 
  Cambridge University Press.

Feret, J.B., Francois, C., Asner, G.P., Gitelson, A.A., 
  Martin, R.E., Bidel, L.P.R., Ustin, S.L., le Maire, G., Jacquemoud, S. (2008),
  PROSPECT-4 and 5: Advances in the leaf optical properties model separating photosynthetic 
  pigments. Remote Sens. Environ. 112, 3030-3043.

Allen W.A., Gausman H.W., Richardson A.J., Thomas J.R.
  (1969), Interaction of isotropic ligth with a compact plant leaf,
  Journal of the Optical Society of American, 59:1376-1379.

Stokes G.G. (1862), On the intensity of the light
  reflected from or transmitted through a pile of plates,
  Proceedings of the Royal Society of London, 11:545-556.
}
