#' Customized Legend for CE and RP plots.
#'
#' @param ... free
#' @importFrom  graphics par
#' @importFrom  graphics plot
#' @importFrom  graphics legend


add_legend <- function(...) {
  opar <- par(fig = c(0, 1, 0, 1),
              oma = c(0, 0, 0, 0),
              mar = c(0, 0, 0, 0),
              new = TRUE)

  on.exit(par(opar))

  plot(0, 0,
       type = 'n',
       bty  = 'n',
       xaxt = 'n',
       yaxt = 'n')

  legend(...)
}
