library(checkargs)
context("isBooleanOrNaScalar")

test_that("isBooleanOrNaScalar works for all arguments", {
  expect_identical(isBooleanOrNaScalar(NULL, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(TRUE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaScalar(FALSE, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaScalar(NA, stopIfNot = FALSE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaScalar(0, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(-1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(-0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(0.1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(1, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(NaN, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(-Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(Inf, stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar("", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar("X", stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(TRUE, FALSE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(FALSE, TRUE), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(NA, NA), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(0, 0), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(-1, -2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(-0.1, -0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(0.1, 0.2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(1, 2), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(NaN, NaN), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(-Inf, -Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c(Inf, Inf), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c("", "X"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_identical(isBooleanOrNaScalar(c("X", "Y"), stopIfNot = FALSE, message = NULL, argumentName = NULL), FALSE)
  expect_error(isBooleanOrNaScalar(NULL, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_identical(isBooleanOrNaScalar(TRUE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaScalar(FALSE, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_identical(isBooleanOrNaScalar(NA, stopIfNot = TRUE, message = NULL, argumentName = NULL), TRUE)
  expect_error(isBooleanOrNaScalar(0, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(-1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(-0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(0.1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(1, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(NaN, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(-Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(Inf, stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar("", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar("X", stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(TRUE, FALSE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(FALSE, TRUE), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(NA, NA), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(0, 0), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(-1, -2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(-0.1, -0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(0.1, 0.2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(1, 2), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(NaN, NaN), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(-Inf, -Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c(Inf, Inf), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c("", "X"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
  expect_error(isBooleanOrNaScalar(c("X", "Y"), stopIfNot = TRUE, message = NULL, argumentName = NULL))
})
