% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_list.R
\name{get_node_list}
\alias{get_node_list}
\title{Get the list of nodes}
\usage{
get_node_list(nodes)
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output of the function
\code{\link[=create_node_labels]{create_node_labels()}}.}
}
\value{
A vector of node labels.
}
\description{
Retrieves the node list by selecting and ordering the column \code{node} of the
output of the function \code{\link[=create_node_labels]{create_node_labels()}}.
}
\examples{
library("chessboard")

# Two-dimensional sampling (only) ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")
get_node_list(nodes)
}
