% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_posthoc_test.R
\name{chisq.posthoc.test}
\alias{chisq.posthoc.test}
\title{Perform post hoc analysis based on residuals of Pearson's Chi-squared Test for Count Data.}
\usage{
chisq.posthoc.test(x, method = "bonferroni", round = 6, ...)
}
\arguments{
\item{x}{A matrix passed on to the chisq.test function.}

\item{method}{The p adjustment method to be used. This is passed on to the p.adjust function.}

\item{round}{Number of digits to round the p.value to. Defaults to 6.}

\item{...}{Additional arguments passed on to the chisq.test function.}
}
\value{
A table with the adjusted p value for each x y combination.
}
\description{
Perform post hoc analysis based on residuals of Pearson's Chi-squared Test for Count Data.
}
\examples{
# Data from Agresti(2007) p.39
M <- as.table(rbind(c(762, 327, 468), c(484, 239, 477)))
dimnames(M) <- list(gender = c("F", "M"),
                   party = c("Democrat","Independent", "Republican"))

# Pass data matrix to chisq.posthoc.test function
chisq.posthoc.test(M)
}
\references{
Agresti, A. (2007). \emph{An Introduction to Categorical Data Analysis}, 2nd
ed. New York: John Wiley & Sons. Page 38.

Beasley, T. M., & Schumacker, R. E. (1995). Multiple Regression Approach
to Analyzing Contingency Tables: Post Hoc and Planned Comparison
Procedures. \emph{The Journal of Experimental Education}, 64(1), 79--93.
}
