% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enchunk.R
\name{add_quotes}
\alias{add_quotes}
\title{Adds additional quotations to character values}
\usage{
add_quotes(x, except = NULL, single_quote = TRUE, collapse = NULL)
}
\arguments{
\item{x}{List or named vector}

\item{except}{Vector specifying the names of the elements that should not be enquoted.}

\item{single_quote}{Use single quotes (') instead of double quotes ("). Default is TRUE.}

\item{collapse}{If not NULL, collapse the values into a single vector using this value as the separator. Default is NULL.}
}
\value{
The list or named vector, with additional quotes around the appropriate values
}
\description{
This is useful when assembling functions calls, where you specify parameter
names and character values at the same time.
}
\examples{
params = list(a = TRUE, b = FALSE, c = 'ABC', d = 15)
add_quotes(params)
add_quotes(params, except = 'c')
}
