% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_interface.R
\name{output_config}
\alias{output_config}
\title{Build the yaml output specification for an R Markdown}
\usage{
output_config(
  output_format,
  title = NULL,
  author = NULL,
  include_date = TRUE,
  number_sections = FALSE,
  table_of_content = FALSE,
  table_of_content_depth = 1,
  fig_width = 8,
  fig_height = 5,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  rmdformats_theme = "downcute",
  prettydoc_theme = "leonids",
  docx_reference_file = NULL,
  pptx_reference_file = NULL,
  html_theme = "simplex",
  rticles_template = "arxiv_article",
  custom_output = NULL
)
}
\arguments{
\item{output_format}{The format of the R Markdown file.}

\item{title}{Title of the report. If NULL (default), no title will be added.}

\item{author}{Author of the report. If NULL (default), no author will be added.}

\item{include_date}{Whether or not to include the date as part of the header. Default is TRUE.}

\item{number_sections}{Whether or not to number the sections and subsections of the report.}

\item{table_of_content}{Whether or not to include a table fo content at the beginning of the report.}

\item{table_of_content_depth}{The depth of sections and subsections to be displayed on the table of content.}

\item{fig_width}{Set the global figure width or the rmarkdown file.}

\item{fig_height}{Set the global figure height or the rmarkdown file.}

\item{plot_palette}{Character vector of hex codes to use on plots.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required. Default value is 'plasma', and possible values are 'viridis', 'inferno', 'magma', 'plasma', 'cividis'.}

\item{rmdformats_theme}{The theme to be used for [rmdformats](https://github.com/juba/rmdformats) outputs. Default is "downcute", and possible values are "downcute", "robobook", "material", "readthedown", "html_clean", "html_docco".}

\item{prettydoc_theme}{Name of the theme used on [prettydoc](https://prettydoc.statr.me/themes.html). Default is "leonids", and ossible values are "cayman", "tactile", "architect", "leonids", "hpstr".}

\item{docx_reference_file}{The path for a blank Microsoft Word document to use as template for the 'word_document' output.}

\item{pptx_reference_file}{The path for a blank Microsoft PowerPoint document to use as template for the 'powerpoint_presentation' output.}

\item{html_theme}{The theme to be used for [hmtl_document](https://www.datadreaming.org/post/r-markdown-theme-gallery/) outputs. Default is "simplex".}

\item{rticles_template}{The theme to be used fo [rticles](https://github.com/rstudio/rticles). Default is "arxiv_article"}

\item{custom_output}{[Experimental] This is to get output formats not currently supported. It should be a YAML element with the corresponding output}
}
\value{
The lines needed in the yaml header of an R Markdown file to render as the specified output type.
}
\description{
Currently supported: prettydoc, ioslides, tufte, flexdashboard, slidy_presentation,
html_document, html_notebook.
}
\examples{
cat(output_config('prettydoc'))
cat(output_config('ioslides'))
}
