% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_to_dag.R
\name{PartitiontoDAG}
\alias{PartitiontoDAG}
\title{Sample DAG from partition}
\usage{
PartitiontoDAG(partitions, scorer)
}
\arguments{
\item{partitions}{A cia_chain(s) object or data.frame representing the
partition.}

\item{scorer}{A scorer object.}
}
\value{
A cia_chain(s) object or adjacency matrix. For a cia_chain(s) object
each state will be an adjacency matrix.
}
\description{
Samples a DAG in accordance with it's posterior probability conditional
on it being consistent with a partition.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partition <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

# Used to sample from a single partition.  
PartitiontoDAG(partition, scorer)

# Used to convert a chain of partitions to DAGs.
results <- SampleChains(3, partition, PartitionMCMC(), scorer)
PartitiontoDAG(results, scorer)

}
