% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_edge_probabilities.R
\name{SampleEdgeProbabilities}
\alias{SampleEdgeProbabilities}
\title{Sample edge probabilities}
\usage{
SampleEdgeProbabilities(x)
}
\arguments{
\item{x}{A chain(s) or collection object where states are DAGs.}
}
\value{
p_edge A posterior sample for the marginalised edge probabilities.
}
\description{
Sample edge probabilities
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)

pedge_sample <- SampleEdgeProbabilities(dag_chains)

}
