% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap_cifti.R
\name{remap_cifti_wrapper}
\alias{remap_cifti_wrapper}
\title{\code{remap_cifti} wrapper}
\usage{
remap_cifti_wrapper(
  original_fnames,
  remap_fnames = NULL,
  remap_method = c("adaptive", "barycentric"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  areaL_target_fname = NULL,
  areaR_target_fname = NULL,
  sphereL_original_fname = NULL,
  sphereR_original_fname = NULL,
  sphereL_target_fname = NULL,
  sphereR_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)
}
\arguments{
\item{original_fnames}{The files to remap. This is a named list
where each element's name is a file type label, and each element's value
is a file name. Labels must be one of the following: "cortexL", "cortexR",
"ROIcortexL", "ROIcortexR". If \code{read_dir} is not \code{NULL}, then all
these file names should be relative to \code{read_dir}.}

\item{remap_fnames}{Where to write the resampled files. This is a named list
where each entry's name is a file type label, and each entry's value
is a file name indicating where to write the corresponding resampled file.
The recognized file type labels are: "cortexL", "cortexR",
"ROIcortexL", "ROIcortexR", "validROIcortexL", and "validROIcortexR".

Entry values can be \code{NULL}, in which case a default file name will be
used: see \code{\link{resample_cifti_default_fname}}. Default file names
will also be used for files that need to be resampled/written but without a
corresponding entry in \code{remap_fnames}.

Entries in \code{remap_fnames} will be ignored if they are not needed
based on \code{[ROI_]brainstructures}. For example, if
\code{brainstructures="left"}, then \code{remap_fnames$cortexR} will be
ignored if specified.

The \code{write_dir} argument can be used to place each resampled file in
the same directory.}

\item{remap_method}{\code{"adaptive"} (default) or \code{"adaptive"}
resampling. These options correspond to the Workbench command options
\code{"BARYCENTRIC"} and \code{"ADAP_BARY_AREA"}, respectively.

For remapping between fs_LR group data and FreeSurfer fsaverage group data,
adaptive resampling should be used.}

\item{areaL_original_fname, areaR_original_fname}{File paths to the surfaces
to use for vertex area correction during adaptive resampling. (Only used if
resampling with the adaptive method.) \code{area[L/R]_original_fname} should
match the current resolution of the data.

For resampling: the Workbench command for adaptive resampling requires the
target surfaces for area correction too. But to make the workflow easier,
\code{ciftiTools} will resample \code{area[L/R]_original_fname} with the
barycentric method and use that for the target area.

For remapping: \code{area[L/R]_target_fname} must be directly provided.}

\item{areaL_target_fname, areaR_target_fname}{File paths to the surfaces
to use for vertex area correction during adaptive resampling. (Only used if
resampling with the adaptive method.) \code{area[L/R]_target_fname} should
match the target resolution of the data.}

\item{read_dir}{Directory to append to the path of every file being read,
e.g. \code{cortexL_original_fname}. If \code{NULL} (default), do not append
any directory to the path.

\code{read_dir} must already exist, or an error will be raised.}

\item{write_dir}{Where should the separate files be placed? \code{NULL}
(default) will write them to the current working directory.

\code{write_dir} must already exist, or an error will occur.}
}
\value{
The return value of the \code{resample_cifti_components} call
}
\description{
Wrapper for \code{remap_cifti}. Calls \code{resample_cifti_components} using
the original file names listed in the \code{original_fnames} argument and
the target file names listed in the \code{remap_fnames} argument.
}
\keyword{internal}
