#' Example peaks from bone marrow of B6 mice
#'
#' @docType data
#'
#' @usage data(atac_seq_consensus_bm)
#'
#' @examples
#' data(atac_seq_consensus_bm)
"bed"


#' Immune modules
#'
#' @docType data
#'
#' @usage data(VP2008)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#'
#' @keywords datasets
#'
#' @references Chaussabel et al. (2008) Immunity 29:150-164
#' (\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2727981/}{PubMed})
#'
"vp2008"


#' Grch38
#'
#' @docType data
#'
#' @usage data(grch38)
#'
#'
#' @keywords datasets
#'
"grch38"

#' Grch37
#'
#' @docType data
#'
#' @usage data(grch37)
#' @keywords datasets
#'
"grch37"


#' Grcm38
#'
#' @docType data
#' @usage data(grcm38)
#' @keywords datasets
#'
"grcm38"
