% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2cff.R
\name{r2cff}
\alias{r2cff}
\title{Convert from R DESCRIPTION into CFF}
\usage{
r2cff(descriptionFile = "DESCRIPTION", export = FALSE)
}
\arguments{
\item{descriptionFile}{either the path to a DESCIPTION file, the path to a main
folder of a package (containing a DESCRIPTION file) or the name of a package.}

\item{export}{if `TRUE`, the output is saved as CITATION.cff in the folder of
the DESCRIPTION file.}
}
\value{
The package's DESCRIPTION file converted to CFF
}
\description{
Converts an R package DESCRIPTION file to Citation File Format
}
\details{
CFF is a standard format for the citation of software proposed by
Stephan Druskat et. al. (see references below). CFF-compliant files are
stored in files named CITATION.cff.

CITATION.cff files are plain text files with human- and machine-readable
citation information for software. Code developers can include them in their
repositories to let others know how to correctly cite their software.
}
\examples{
r2cff("citation")
}
\references{
Druskat S., Spaaks J.H., Chue Hong N., Haines R., Baker J. (2019).
Citation File Format (CFF) (version 1.1.0).
DOI: http://doi.org/10.5281/zenodo.1003149

https://www.software.ac.uk/blog/2017-12-12-standard-format-citation-files
https://citation-file-format.github.io
https://github.com/citation-file-format/citation-file-format/blob/master/README.md
https://citation-file-format.github.io/cff-initializer-javascript/
}
\seealso{
cff2r
}
\author{
Waldir Leoncio, Jan Philipp Dietrich
}
