% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_search.R
\name{tag_search}
\alias{tag_search}
\title{Search tags.}
\usage{
tag_search(
  query = NULL,
  vocabulary_id = NULL,
  offset = 0,
  limit = 31,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{query}{(character) A tag name query to search for, if given only tags
whose names contain this string will be returned; one or more search
strings}

\item{vocabulary_id}{(character) The id or name of a vocabulary,
if give only tags that belong to this vocabulary will be returned}

\item{offset}{(numeric) Where to start getting activity items from
(optional, default: 0)}

\item{limit}{(numeric) The maximum number of activities to return
(optional, default: 31)}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Search tags.
}
\examples{
\dontrun{
tag_search(query = 'ta')
tag_search(query = c('ta', 'al'))

# different formats back
tag_search(query = 'ta', as = 'json')
tag_search(query = 'ta', as = 'table')
}
}
