% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clda.R
\name{clda.classify}
\alias{clda.classify}
\title{cLDA classify}
\usage{
clda.classify(model, Data)
}
\arguments{
\item{model}{An object returned by the function \code{\link{clda.model}}.}

\item{Data}{Matrix of time series on the rows.}
}
\value{
A list containing the predicted labels of the time series
and a matrix of distances between the time series and the centroids after applying
the filters obtained by \code{\link{clda.model}}.
}
\description{
Classify the time series and obtain the distances between the time series and the centroids of each class.
}
\examples{

## Generating 200 time series of length 100 with label 1
time_series_signal_1 = sin(matrix(runif(200*100),nrow = 200,ncol = 100))
time_series_error_1 = matrix(rnorm(200*100),nrow = 200,ncol = 100)
time_series_w_label_1 = time_series_signal_1 + time_series_error_1
## Generating another 200 time series of length 100 with label 2
time_series_signal_2 = cos(matrix(runif(200*100),nrow = 200,ncol = 100))
time_series_error_2 = matrix(rnorm(200*100),nrow = 200,ncol = 100)
time_series_w_label_2 = time_series_signal_2 + time_series_error_2
## Join the time series data in one matrix
time_series_data = rbind(time_series_w_label_1,time_series_w_label_2)
label_time_series   = c(rep(1,200),rep(2,200))
clda_model <- clda.model(time_series_data,label_time_series)
## Create a test set
## data with label 1
Data_test_label_1 = sin(matrix(runif(50*100),nrow = 50,ncol = 100))
## data with label 2
Data_test_label_2 = cos(matrix(runif(50*100),nrow = 50,ncol = 100))
## join data into a single matrix
Data_test = rbind(Data_test_label_1,Data_test_label_2)
## obtain the labels and distances of each time series
clda.classify(clda_model,Data_test)
}
\seealso{
\code{\link{clda.model}}
}
\author{
Grover E. Castro Guzman

André Fujita
}
\keyword{classification}
