% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clda.R
\name{clda.model}
\alias{clda.model}
\title{cLDA Model}
\usage{
clda.model(Data, Labels)
}
\arguments{
\item{Data}{Matrix of time series on the rows.}

\item{Labels}{Label of each time series.}
}
\value{
A list containing the filters and their respective importance (g and eig_val),
the class means (Means), the average of the class means (Mean), and the labels of each class mean (classes). The filters are the columns of the matrix g.
}
\description{
Obtains a set of filters for labeled time series data
so that the between-class distances are maximized, and the within-class
distances are minimized.
}
\examples{
## Generating 200 time series of length 100 with label 1
time_series_signal_1 = sin(matrix(runif(200*100),nrow = 200,ncol = 100))
time_series_error_1 = matrix(rnorm(200*100),nrow = 200,ncol = 100)
time_series_w_label_1 = time_series_signal_1 + time_series_error_1
## Generating another 200 time series of length 100 with label 2
time_series_signal_2 = cos(matrix(runif(200*100),nrow = 200,ncol = 100))
time_series_error_2 = matrix(rnorm(200*100),nrow = 200,ncol = 100)
time_series_w_label_2 = time_series_signal_2 + time_series_error_2
## Join the time series data in one matrix
time_series_data = rbind(time_series_w_label_1,time_series_w_label_2)
label_time_series   = c(rep(1,200),rep(2,200))
## obtain the model with the given data
clda.model(time_series_data,label_time_series)
}
\author{
Grover E. Castro Guzman

André Fujita
}
\keyword{model}
