% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_interval.R
\name{animate_interval}
\alias{animate_interval}
\title{Generate animated plot}
\usage{
animate_interval(obj, interval)
}
\arguments{
\item{obj}{A \emph{cleanTS} object.}

\item{interval}{A numeric or character, specifying the viewing interval.}
}
\value{
A list containing:
\itemize{
\item animation: A \code{gganim} object.
\item nstates: The number of states in the animation.
}
}
\description{
\code{animate_interval()} creates an animated plot using a \code{cleanTS} object
and a interval.
}
\details{
First, the data is split according to the \code{interval} argument passed to the
function. If it is a numeric value, the cleaned data is split into dataframes
containing \code{interval} observations. It can also be a string, like
\strong{1 week}, \strong{3 months}, \strong{14 days}, etc. In this case, the data
is split according to the \code{interval} given, using the timestamp column. Then
an animation is created using the spliited data, with the help of \code{gganimate}
package. The \code{animate_interval()} function returns a list containing
the \code{gganim} object used to generate the animation and the number of
states in the data. The animation can be generated using the
\code{gen.animation()} function and saved using the \code{anim_save()}
function. The plots in the animation also contain a short summary, containing
the statistical information and the number of missing values, outliers,
missing timestamps, and duplicate timestamps in the data shown in that frame
of animation.
}
\examples{
\dontrun{
  # Create a `gganim` using `animate_interval()` function
  a <- animate_interval(cts, "10 year")

  # cts -> `cleanTS` object created using `cleanTS()`.
}

}
