% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_creat_neo.R
\name{calc_creat_neo}
\alias{calc_creat_neo}
\title{Estimate serum creatinine in neonates}
\usage{
calc_creat_neo(pma = NULL, digits = 1)
}
\arguments{
\item{pma}{post-natal age in weeks}

\item{digits}{number of digits to round to}
}
\description{
Calculate an estimated serum creatinine. Function takes vectorized input as well.
}
\details{
Uses equations described in Germovsek E et al. (http://www.ncbi.nlm.nih.gov/pubmed/27270281)
based on data from Cuzzolin et al. (http://www.ncbi.nlm.nih.gov/pubmed/16773403) and
Rudd et al. (http://www.ncbi.nlm.nih.gov/pubmed/6838252)
}
\examples{
cr <- calc_creat_neo(pma = 36)
convert_creat_unit(cr$value, unit_in = cr$unit, unit_out = "mg/dL")
}
