% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_titles_footnotes.R
\name{clin_add_titles}
\alias{clin_add_titles}
\alias{clin_add_footnotes}
\alias{clin_add_footnote_page}
\title{Add titles, footnotes, or a footnote page to a clintable or clindoc}
\usage{
clin_add_titles(x, ls = NULL, ft = NULL)

clin_add_footnotes(x, ls = NULL, ft = NULL)

clin_add_footnote_page(x, ls = NULL, ft = NULL)
}
\arguments{
\item{x}{a clintable object}

\item{ls}{a list of character vectors, no more than 2 elements to a vector}

\item{ft}{A flextable object to use as the header}
}
\value{
A clintable object
}
\description{
This function allows you to attach specified titles, footnotes, or a footnote page
into clintable or clindoc object. The input can be provided either as a list of character
vectors, or pre-built flextable.
}
\details{
When using the \code{ls} parameter, each element of the list can contain no more than two
elements within each character vector. In a title, a single element will align center.
In a footnote, a single element will align to the left. For both titles and footnotes,
two elements will align split down the middle, with the left side element aligning left
and the right side element aligning right. In a title, a single left aligned element,
provide a 2 element character vector with duplicate values.
}
\examples{
clintable(mtcars) |>
  clin_add_titles(
    list(
      c("Left", "Right"),
      c("Just the middle")
    )
  ) |>
  clin_add_footnotes(
    list(
      c(
        "Here's a footnote.",
        format(Sys.time(), "\%H:\%M \%A, \%B \%d, \%Y")
      )
    )
  ) |>
  clin_add_footnote_page(
    list(
      c(
        "Use when you have a lot of footnotes",
        "And you don't want to put them on every page"
      )
    )
  )

}
\concept{add_titles_footnotes}
