% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinspacy.R
\name{bind_clinspacy_embeddings}
\alias{bind_clinspacy_embeddings}
\title{This function binds columns containing entity or concept embeddings to a data
frame. The entity embeddings are derived from the scispacy package, and the
concept embeddings are derived from the
\code{\link{dataset_cui2vec_embeddings}} dataset included with this package.}
\usage{
bind_clinspacy_embeddings(
  clinspacy_output,
  df,
  type = "scispacy",
  df_id = NULL,
  subset = "is_negated == FALSE"
)
}
\arguments{
\item{clinspacy_output}{A data.frame or file name containing the output from
\code{\link{clinspacy}}. In order for scispacy embeddings to be available
to \code{\link{bind_clinspacy_embeddings}}, you must set
\code{return_scispacy_embeddings} to \code{TRUE} when running
\code{\link{clinspacy}} so that the embeddings are included within
\code{clinspacy_output}.}

\item{df}{The data.frame to which you would like to bind the output of
\code{\link{clinspacy}}.}

\item{type}{The type of embeddings to return. One of \code{scispacy} and
\code{cui2vec}. Whereas \code{cui2vec} embeddings require the UMLS linker
to be enabled, the \code{scispacy} embeddings do not. Defaults to
\code{scispacy}.}

\item{df_id}{The name of the \code{id} column in the data frame with which
the \code{id} column in \code{clinspacy_output} will be joined. If you
supplied a \code{df_id} in \code{\link{clinspacy}}, then you must also
supply it here. If you did not supply it in \code{\link{clinspacy}}, then
it will default to the row number (similar behavior to in
\code{\link{clinspacy}}).}

\item{subset}{Logical criteria represented as a string by which the
\code{clinspacy_output} will be subsetted prior to building the output data
frame. Defaults to \code{"is_negated == FALSE"}, which removes negated
concepts prior to generating the output. Any column in
\code{clinspacy_output} may be referenced here. To avoid any subsetting,
set this to \code{NULL}.}
}
\value{
A data frame containing the original data frame as well as the
  concept embeddings. For scispacy embeddings, this returns 200 columns of
  embeddings. For cui2vec embeddings, this returns 500 columns of embedings.
  The resulting data frame can be used to train a machine learning model.
}
\description{
The embeddings are derived from Andrew Beam's
\href{https://github.com/beamandrew/cui2vec}{cui2vec R package}.
}
\details{
Citation

Beam, A.L., Kompa, B., Schmaltz, A., Fried, I., Griffin, W, Palmer, N.P.,
Shi, X., Cai, T., and Kohane, I.S.,, 2019. Clinical Concept Embeddings
Learned from Massive Sources of Multimodal Medical Data. arXiv preprint
arXiv:1804.01486.

License

The cui2vec data is made available under a
\href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0 license}. The
only change made to the original dataset is the renaming of columns.
}
\examples{
\dontrun{
mtsamples <- dataset_mtsamples()
mtsamples[1:5,] \%>\%
  clinspacy(df_col = 'description', return_scispacy_embeddings = TRUE) \%>\%
  bind_clinspacy_embeddings(mtsamples[1:5,])
}

}
