% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{reports_summary}
\alias{reports_summary}
\title{Summary report}
\usage{
reports_summary(start, end, extra_args = list())
}
\arguments{
\item{start}{Start time}

\item{end}{End time}

\item{extra_args}{Extra arguments to be passed to the
\href{https://docs.clockify.me/#tag/Time-Entry-Report/operation/generateSummaryReport}{API}.
Example: \code{extra_args = list(rounding = TRUE)}.}
}
\value{
A data frame with summarised time entries for the specified time period.
}
\description{
Summary report
}
\examples{
\dontrun{
report <- reports_summary("2022-08-01", "2022-09-01")

# Summary per user.
report
# Summary per client/project.
report \%>\%
  select(-duration, -amount, -amounts) \%>\%
  unnest(projects)
# Summary per time entry.
report \%>\%
  select(-duration, -amount, -amounts) \%>\%
  unnest(projects) \%>\%
  select(-duration, -amount) \%>\%
  unnest(entries)
}
}
