% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustTMB.R
\name{clustTMB}
\alias{clustTMB}
\title{Fit a finite mixture model using TMB}
\usage{
clustTMB(
  response = NULL,
  expertformula = ~1,
  gatingformula = ~1,
  expertdata = NULL,
  gatingdata = NULL,
  family = gaussian(link = "identity"),
  Offset = NULL,
  G = 2,
  rr = list(spatial = NULL, temporal = NULL, random = NULL),
  covariance.structure = NULL,
  Start = list(),
  Map = list(),
  initialization.args = list(control = init.options()),
  spatial.list = list(loc = NULL, mesh = NULL, init.range = list(gating.range = NULL,
    expert.range = NULL)),
  projection.dat = NULL,
  control = run.options()
)
}
\arguments{
\item{response}{A numeric vector, matrix, or data frame of observations. When data are multivariate, rows correspond to observations and columns correspond to the multivariate response.}

\item{expertformula}{Formula defining expert model. This formula corresponds to the covariates included in the response densities. Defaults to intercept only (~1) when no covariates are used.}

\item{gatingformula}{Formula defining gating model.  This formula corresponds to the covariates included in the mixing proportions (logistic regression). Defaults to intercept only (~1) when no covariates are used. When a random effects term is included in the gating network, this formula will be updated so that the intercept term is removed.}

\item{expertdata}{Data frame containing expert model covariates.}

\item{gatingdata}{Data frame containing gating model covariates.}

\item{family}{Statistical distribution and link function of observations.}

\item{Offset}{Constant in expertformula only used to offset density expectation.}

\item{G}{Integer specifying the number of clusters.}

\item{rr}{List specifying dimension of rank reduction in spatial, temporal, and/or random effects. Dimension must be smaller than the total dimension of the response. Rank reduction is applied only to the expertformula random effects. The rank reduction reduces the dimensionality of a correlated multivariate response to a smaller dimension independent response. When used, the covariance structure of the response is switched to 'Diagonal.' Defaults to NULL, no rank reduction. If rank reduction is used in conjunction with a random effect, that random effect must also be specified in the expert formula. Currently, rank reduction on temporal random effects is disabled.}

\item{covariance.structure}{A character string specifying the covariance structure of the response using mclust naming scheme. See description of modelNames under ?Mclust for details.}

\item{Start}{Set initial values for random effects parameters (fixed and random terms)}

\item{Map}{Vector indicating parameter maps, see ?\code{\link[TMB:MakeADFun]{TMB::MakeADFun()}} for details. Defaults in clustTMB control this map argument and user input is limited}

\item{initialization.args}{A list consisting of initialization settings used to generate initial values.
control Calls \code{\link[=init.options]{init.options()}} to generate settings for initial values. Arguments of \code{\link[=init.options]{init.options()}} can be specified by the user.
\enumerate{
\item init.method - Single character string indicating initial clustering method. Methods include: hc, quantile, random, mclust, kmeans, mixed, user. Defaults to 'hc'. In the case where data are univariate and there are no covariates in the gating/expert formula, this defaults to 'quantile'
\item hc.options - Named list of two character strings specifying hc modelName and hcUse when init.method = 'hc'. The default modelName is 'VVV' and the default use is 'SVD' unless gating/expert covariates specified, in which case default in VARS. See ?mclust::mclust.options for complete list of options.
\item mix.method - String stating initialization method for mixed-type data (init.method = 'mixed'). Current default when Tweedie family specified. Options include: Gower kmeans (default), Gower hclust, and kproto.
\item user - Numeric or character vector defining user specified initial classification. init.method must be set to 'user' when using this option.
}}

\item{spatial.list}{List of data objects needed when fitting a spatial GMRF model}

\item{projection.dat}{Spatial Points class of projection coordinates or Spatial Points Dataframe containing projection coordinates and projection covariates}

\item{control}{List controlling whether models are run and whether standard errors are calculated.}
}
\value{
list of objects from fitted model
}
\description{
Fit a finite mixture model using TMB
}
\examples{
data("faithful")
m1 <- clustTMB(response = faithful, covariance.structure = "VVV")
plot(faithful$eruptions, faithful$waiting, pch = 16, col = m1$report$classification + 1)
}
