# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

parse_ms_positions <- function(line) {
    .Call(`_coala_parse_ms_positions`, line)
}

parse_ms_output <- function(file_names, sample_size, loci_number) {
    .Call(`_coala_parse_ms_output`, file_names, sample_size, loci_number)
}

parse_seqgen_output <- function(output, individuals, locus_length, locus_number, outgroup_size, calc_segsites = TRUE) {
    .Call(`_coala_parse_seqgen_output`, output, individuals, locus_length, locus_number, outgroup_size, calc_segsites)
}

generate_trio_trees <- function(trees, trio_dists, file_names) {
    .Call(`_coala_generate_trio_trees`, trees, trio_dists, file_names)
}

#' @describeIn segsites Creates segregating sites
#'
#' @param snps The SNP Matrix (see Details).
#' @param positions A numeric vector indicating the relative positions of each
#'   SNP on the locus (see Details).
#' @param trio_locus If the locus consists of a locus trio (see Details).
#' @param check Whether non-segregating sites are removed from the segregating
#'   sites (\code{TRUE}) or not (\code{FALSE}).
#' @export
#'
create_segsites <- function(snps, positions, trio_locus = numeric(0), check = TRUE) {
    .Call(`_coala_create_segsites`, snps, positions, trio_locus, check)
}

#' @describeIn segsites Returns the SNP matrix from a segregating sites
#'  object.
#'
#' @param segsites The segregating sites object
#' @export
get_snps <- function(segsites) {
    .Call(`_coala_get_snps`, segsites)
}

#' @describeIn segsites Returns the SNP's positions from a segregating
#'   sites  object.
#' @export
get_positions <- function(segsites) {
    .Call(`_coala_get_positions`, segsites)
}

#' @describeIn segsites Sets the SNP's positions in a segregating
#'   sites object.
#' @export
set_positions <- function(segsites, positions) {
    .Call(`_coala_set_positions`, segsites, positions)
}

#' @describeIn segsites Returns the trio locus positions from a
#'   segregating sites  object.
#' @export
get_trio_locus <- function(segsites) {
    .Call(`_coala_get_trio_locus`, segsites)
}

#' @describeIn segsites Sets the trio locus in a segregating sites
#'   object.
#' @export
set_trio_locus <- function(segsites, trio_locus) {
    .Call(`_coala_set_trio_locus`, segsites, trio_locus)
}

calc_four_gamete_stat <- function(seg_sites_list, individuals, locus_length, ploidy = 1L, narm = 0L) {
    .Call(`_coala_calc_four_gamete_stat`, seg_sites_list, individuals, locus_length, ploidy, narm)
}

#' Calculates the Joint Site Frequency Spectrum
#'
#' @param segsites_list List of segregating sites
#' @param ind_per_pop A list of integer vector, where each entry gives the
#'   index of the haploids that belong the corresponding population.
#'
#' @author Paul Staab & Dirk Metzler
#' @return The Joint Site Frequency Spectrum, as a matrix.
#' @keywords internal
calc_jsfs <- function(segsites_list, ind_per_pop) {
    .Call(`_coala_calc_jsfs`, segsites_list, ind_per_pop)
}

calc_mcmf <- function(seg_sites, individuals, has_trios = TRUE, expand_mcmf = FALSE, type_expand = 1L, ploidy = 1L, locus_length = matrix(0)) {
    .Call(`_coala_calc_mcmf`, seg_sites, individuals, has_trios, expand_mcmf, type_expand, ploidy, locus_length)
}

calc_nucleotide_div <- function(segsites_list, individuals) {
    .Call(`_coala_calc_nucleotide_div`, segsites_list, individuals)
}

unphase_segsites <- function(seg_sites_list, ploidy, samples_per_ind) {
    .Call(`_coala_unphase_segsites`, seg_sites_list, ploidy, samples_per_ind)
}

