% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_findSATE2.R
\name{findSATE2}
\alias{findSATE2}
\title{Find the cutoff values of biomarkers based on the standardized average subpopulation treatment effect}
\usage{
findSATE2(z2interval, kkk, muminusmu0, kappa, rhovec, sigma, cLam)
}
\arguments{
\item{z2interval}{a numeric vector of two values, including the lower and upper limits of the initial interval for z2}

\item{kkk}{the researchers' weighting preference between the two biomarkers}

\item{muminusmu0}{a number of the difference between the mean of outcome and the minimal clinically important treatment effect}

\item{kappa}{a number of the correlation coefficient between two biomarkers}

\item{rhovec}{a numeric vector of two correlation coefficients between the output and two biomarkers}

\item{sigma}{a number of the standard deviation of outcome}

\item{cLam}{the desired standardized average subpopulation treatment effect}
}
\value{
a numeric vector of two values which are the cutoff values for z1 and z2
}
\description{
Find the cutoff values of biomarkers based on the standardized average subpopulation treatment effect
}
\examples{
z2interval <- c(-4, 4)
kkk <- 1
muminusmu0 <- 1.8
kappa <- 0.1
rhovec <- c(0.1, 0.2)
sigma <- 1
cLam <- 2.5
findSATE2(z2interval, kkk, muminusmu0, kappa, rhovec, sigma, cLam)
}
\references{
Zhang, F. and Gou, J. (2025). Using multiple biomarkers for patient enrichment in two-stage clinical designs. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
