% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcodeC1.R
\name{coco1}
\alias{coco1}
\title{Type 1 Rank correlation coefficient based test on positive dependence through stochastic ordering}
\usage{
coco1(cordx, cordy, alpha = 0.05, Rboot = 100, seed = 1)
}
\arguments{
\item{cordx}{a numeric vector}

\item{cordy}{a numeric vector}

\item{alpha}{a number of significance level}

\item{Rboot}{a number of bootstrap replicates}

\item{seed}{a number of the seed of random number generator}
}
\value{
a vector of three numbers: a lower bound of one-sided confidence interval \code{lower_bound}, a test statistic \code{estimation}, and an indicator whether the PDS condition holds or not \code{PDS_assumption}
}
\description{
This function evaluates the assumption of positive dependence through stochastic ordering in multiple comparison procedures
}
\details{
R package \code{boot} is included for computing nonparametric bootstrap confidence intervals
}
\examples{
set.seed(123)
cordx <- rnorm(40)
cordy <- rnorm(40)
coco1(cordx, cordy)

}
\references{
Gou, J., Wu, K. and Chen, O. Y. (2024). Rank correlation coefficient based tests on positive dependence through stochastic ordering with application in cancer studies, Technical Report.
Gou, J. (2023). On dependence assumption in p-value based multiple test procedures. \emph{Journal of Biopharmaceutical Statistics}, 33(5), 596-610.
Gou, J. (2024). A test of the dependence assumptions for the Simes-test-based multiple test procedures. \emph{Statistics in Biopharmaceutical Research}, 16(1), 1-7.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
