% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels.code}
\alias{labels.code}
\alias{to_labels}
\title{Convert vector with codes to factor using a code list}
\usage{
\method{labels}{code}(
  object,
  missing = TRUE,
  droplevels = FALSE,
  codelist = attr(object, "codelist"),
  locale = cl_locale(codelist),
  ...
)

to_labels(
  x,
  codelist = attr(x, "codelist"),
  missing = TRUE,
  droplevels = FALSE,
  locale = cl_locale(codelist)
)
}
\arguments{
\item{object}{vector with codes. Should be of the same type as the codes in
the codelist.}

\item{missing}{convert codes that are missing value to missing values.}

\item{droplevels}{remove labels that do not occur in \code{x}.}

\item{codelist}{a \code{\link{codelist}} object or a \code{data.frame} that
is a valid code list.}

\item{locale}{use the codes from the given locale. Should be character
vector of length 1.}

\item{...}{ignored}

\item{x}{vector with codes. Should be of the same type as the codes in the
codelist.}
}
\value{
A factor vector with the same length as \code{x}.
}
\description{
Convert vector with codes to factor using a code list
}
\details{
\code{to_labels} calls \code{labels.code} directly and is meant as a
substitute for \code{labels.code} for objects that are not of type 'code'.
}
\examples{
data(objectsales)
data(objectcodes)
objectsales$product <- code(objectsales$product, objectcodes)

labels(objectsales$product) |> 
  table(useNA = "ifany")
labels(objectsales$product, missing = FALSE) |> 
  table(useNA = "ifany")
labels(objectsales$product, droplevels = TRUE) |> 
  table(useNA = "ifany")

to_labels(c("A", "B"), codelist = objectcodes)
# is the same as 
labels.code(c("A", "B"), codelist = objectcodes)

}
