% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{sim.strat}
\alias{sim.strat}
\title{Simulate the radiocarbon dating of random depths of a sediment which has accumulated over time.}
\usage{
sim.strat(
  name = "mystrat",
  age.min = 4321,
  length = 800,
  n = 5,
  offset = 0,
  scatter = 2 * error,
  error = 0.02,
  min.error = 10,
  rounded = 0,
  strat.dir = "strats",
  sep = ",",
  cc = 1,
  postbomb = FALSE,
  ask = TRUE
)
}
\arguments{
\item{name}{Name of the simulated stratigraphy. Defaults to \code{"mystrat"}.}

\item{age.min}{Minimum age of the simulation.}

\item{length}{Length of the sequence.}

\item{n}{The amount of dated depths.}

\item{offset}{The ages could be offset by some constant value. Defaults to 0.}

\item{scatter}{There is always a degree of scatter between measurements, and the amount of scatter can be modelled using, e.g., \code{scatter=2*error}. Set at 0 to model radiocarbon dates that are 100\% faithful to the calibration curve (very unlikely!).}

\item{error}{Laboratory error of the radiocarbon dates as percentage of the mean. Defaults to 0.02.}

\item{min.error}{Minimum laboratory to be reported. Defaults to 10 (C-14 year).}

\item{rounded}{Rounding of the simulated calendar years. Rounds to single years (0 decimals) by default.}

\item{strat.dir}{The directory where the folders of the individual trees live. Defaults to \code{tree.dir="trees"}.}

\item{sep}{Separator for the fields in the .csv file. Defaults to a comma.}

\item{cc}{Calibration curve to be used. Could be 1 (IntCal20; default), 2 (Marine20), 3 (SHCal20) or 4 (custom curve).}

\item{postbomb}{Negative C-14 ages (younger than 0 cal BP or AD 1950) should be modelled using a postbomb curve. This could be 1 (northern-hemisphere region 1), 2 (NH region 2), 3 (NH region 3), 4 (southern hemisphere regions 1-2), or 5 (SH region 3).}

\item{ask}{Ask if a folder may be made and files written into it}
}
\value{
A file containing 5 columns: the simulated calendar ages, the radiocarbon ages, their errors, their relative positions (starting with the youngest one at top, and counting upward going down the sequence), and the calibration curve to be used.
}
\description{
Simulate the radiocarbon dating (or with dates that are already on the cal BP scale) of a deposit that is known to have accumulated over time, and for which therefore the dated depths can be safely assumed to be in chronological order.
}
\details{
Dates further down the sequence should have older ages than dates further up, even though owing to scatter, the dates themselves might not be in exact chronological order. The modelling is performed in a Bayesian framework (see \code{strat}). The amount of scatter, the laboratory error and an offset can also be modelled.
}
\examples{
  stratdir <- tempdir()
  sim.strat("ordered.mud", age.min=1000, length=5000, n=10, strat.dir=stratdir)
}
\author{
Maarten Blaauw, J. Andres Christen
}
