% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhrm.R
\name{mhrm}
\alias{mhrm}
\title{MHRM Parameter Estimates for Multiple Chains}
\usage{
mhrm(
  y = y,
  obj_fun = NULL,
  link = NULL,
  est_omega = TRUE,
  est_lambda = TRUE,
  est_zeta = TRUE,
  est_nu = TRUE,
  omega0 = NULL,
  gamma0 = NULL,
  lambda0 = NULL,
  zeta0 = NULL,
  nu0 = NULL,
  kappa0 = NULL,
  omega_mu = NULL,
  omega_sigma2 = NULL,
  lambda_mu = NULL,
  lambda_sigma2 = NULL,
  zeta_mu = NULL,
  zeta_sigma2 = NULL,
  nu_mu = NULL,
  nu_sigma2 = NULL,
  constraints = NULL,
  J = NULL,
  M = NULL,
  N = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{obj_fun}{A function that calculates predictions and log-likelihood
values for the selected model (character).}

\item{link}{Choose between "logit" or "probit" link functions.}

\item{est_omega}{Determines whether omega is estimated (logical).}

\item{est_lambda}{Determines whether lambda is estimated (logical).}

\item{est_zeta}{Determines whether zeta is estimated (logical).}

\item{est_nu}{Determines whether nu is estimated (logical).}

\item{omega0}{Starting values for omega.}

\item{gamma0}{Either a matrix of contrast codes (JM by MN)
or the name in quotes of the desired R stats contrast function (i.e.,
"contr.helmert", "contr.poly", "contr.sum", "contr.treatment", or
"contr.SAS"). If using the R stats contrast function the user must also
specify J, M, and N, as well as ensure that items in y are arranged so that
the first set of I items correspond to the first level if the contrast, the
next set of I items correspond to the second level of the contrast, etc. For
example, in an experiment with two conditions (i.e., J = 2) where the user
requests two contrasts (i.e., N = 2) from the "contr.treatment" function, the
first set of I items will all receive a contrast code of 0 and the second set
of I items will all receive a contrast code of 1. In an experiment with three
conditions (i.e., J = 3) where the user requests three contrasts (i.e.,
N = 3) from the "contr.poly" function, first set of I items will receive the
lowest value code for linear and quadratic contrasts, the second set of I
items will all receive the middle value code for linear and quadratic
contrasts, and the last set of I items will all receive the highest value
code for linear and quadratic contrasts.}

\item{lambda0}{Item slope matrix (IJ by JM).}

\item{zeta0}{Starting values for zeta.}

\item{nu0}{Starting values for nu (IJ by 1).}

\item{kappa0}{Item guessing matrix  (IJ by 1).}

\item{omega_mu}{Vector of means prior for omega (1 by MN).}

\item{omega_sigma2}{Covariance matrix prior for omega (MN by MN).}

\item{lambda_mu}{Mean prior for lambda (1 by JM)}

\item{lambda_sigma2}{Covariance prior for lambda (JM by JM)}

\item{zeta_mu}{Vector of means prior for zeta (1 by JM).}

\item{zeta_sigma2}{Covariance matrix prior for zeta (JM by JM).}

\item{nu_mu}{Prior mean for nu (scalar).}

\item{nu_sigma2}{Prior variance for nu (scalar).}

\item{constraints}{Item parameter constraints.}

\item{J}{Number of conditions (required if using the R stats contrast
function).}

\item{M}{Number of ability (or trait) dimensions (required if using the R
stats contrast function).}

\item{N}{Number of contrasts including intercept (required if using the R
stats contrast function).}

\item{verbose}{Logical (TRUE or FALSE) indicating whether to print progress.}

\item{...}{Additional arguments.}
}
\value{
List with elements for all parameters estimated, information values
for all parameters estimated, and the model log-likelihood value.
}
\description{
This function calculates mhrm parameter estimates for multiple chains.
}
\references{
Cai, L. (2010). High-dimensional exploratory item factor analysis by a
Metropolis-Hastings Robbins-Monro algorithm. \emph{Psychometrika, 75(1)},
33-57.

Cai, L. (2010). Metropolis-Hastings Robbins-Monro algorithm for confirmatory
item factor analysis. \emph{Journal of Educational and Behavioral Statistics,
35(3)}, 307-335.
}
\keyword{internal}
