% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{get_crypto_map}
\alias{get_crypto_map}
\title{Get active cryptocurrencies}
\usage{
get_crypto_map(...)
}
\arguments{
\item{...}{Further arguments passed to the request. Further information
can be found in the \href{https://coinmarketcap.com/api/documentation/v1/#operation}{API documentation}}
}
\value{
A dataframe with all active cryptocurrencies supported by the
platform including a unique id for each cryptocurrency.
}
\description{
Get all active cryptocurrencies supported by the
platform including a unique id
}
\examples{
\dontrun{
get_crypto_map()
get_crypto_map(symbol="BTC")
get_crypto_map(symbol=c("BTC","ETH"))
get_crypto_map(listing_status = "active", start = 1, limit = 10)
get_crypto_map(listing_status = "inactive", start = 1, limit = 10)
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1CryptocurrencyMap}{API documentation}
}
\seealso{
Other Cryptocurrencies: 
\code{\link{get_crypto_listings}()},
\code{\link{get_crypto_marketpairs}()},
\code{\link{get_crypto_meta}()},
\code{\link{get_crypto_ohlcv}()},
\code{\link{get_crypto_quotes}()},
\code{\link{get_marketcap_ticker_all}()},
\code{\link{get_valid_currencies}()}
}
\concept{Cryptocurrencies}
