% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.cointmonitoR}
\alias{print.cointmonitoR}
\title{Print Method for Monitoring Procedures.}
\usage{
\method{print}{cointmonitoR}(x, ..., digits = getOption("digits"))
}
\arguments{
\item{x}{[\code{cointmonitoR}]\cr
Object of class \code{"cointmonitoR"}, i.e. the result of
\code{monitorStationarity()} or \code{monitorCointegration()}.}

\item{...}{ignored}

\item{digits}{[\code{numeric}]\cr
Number of significant digits to be used.}
}
\value{
The invisible \code{x} object.
}
\description{
Printing objects of class \code{"cointmonitoR"}.
}
\examples{
set.seed(42)
test = monitorStationarity(rnorm(100), m = 0.5)
print(test)

x = data.frame(x1 = cumsum(rnorm(200)), x2 = cumsum(rnorm(200)))
eps1 = rnorm(200, sd = 2)
eps2 = c(eps1[1:100], cumsum(eps1[101:200]))
y1 = x$x1 - x$x2 + 10 + eps1
y2 = x$x1 - x$x2 + 10 + eps2
test1 = monitorCointegration(x = x, y = y1, m = 0.5, model = "FM")
print(test1)
test2 = monitorCointegration(x = x, y = y2, m = 0.5, model = "FM")
print(test2)

}
\seealso{
Other cointmonitoR: \code{\link{monitorCointegration}},
  \code{\link{monitorStationarity}},
  \code{\link{plot.cointmonitoR}}
}

