% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_graph.R
\name{tree_graph}
\alias{tree_graph}
\title{Tree Graph}
\usage{
tree_graph(
  initial_value,
  max_orbit_distance,
  P = 2,
  a = 3,
  b = 1,
  cycle_prevention = list()
)
}
\arguments{
\item{initial_value}{(int) The root value of the directed tree graph.}

\item{max_orbit_distance}{(int) Maximum amount of times to iterate the
reverse function. There is no natural termination to populating the tree
graph, equivalent to the termination of hailstone sequences or stopping time
attempts, so this is not an optional argument like max_stopping_time or
max_total_stopping_time, as it is the intended target of orbits to obtain,
rather than a limit to avoid uncapped computation.}

\item{P}{(numeric|bigz): Modulus used to divide
n, iff n is equivalent to (0 mod P). Default is 2.}

\item{a}{(numeric|bigz) Factor by which to multiply n. Default is 3.}

\item{b}{(numeric|bigz) Value to add
to the scaled value of n. Default is 1.}

\item{cycle_prevention}{(set[int]) Used to prevent cycles from precipitating
by keeping track of all values added across previous nest depths. Only to be
used internally by the function recursing. Does not expect input.}
}
\value{
A set of nested dictionaries.
}
\description{
Determine the Tree Graph to some depth by iteratively reversing values.
}
\details{
Returns nested dictionaries that model the directed tree graph up to a
maximum nesting of max_orbit_distance, with the initial_value as the root.
}
\examples{
#Compute a tree graph, which takes both a value to initialise the tree from,
# and an "orbit distance" for how many layers deep in the tree to compute;
tree_graph(16, 3)
# It will also stop on finding a cycle;
tree_graph(4, 3)
# And can be parameterised;
tree_graph(1, 1, -3, -2, -5)
# If b is a multiple of a, but not of Pa, then 0 can have a reverse;
tree_graph(0, 1, 17, 2, -6)
# The tree graph can run on `bigz`;
tree_graph((27+as.bigz("576460752303423488")), 3)
}
