% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorednoise-package.R
\docType{package}
\name{colorednoise-package}
\alias{colorednoise}
\alias{colorednoise-package}
\title{colorednoise: Simulate Temporally Autocorrelated Populations}
\description{
Temporally autocorrelated populations are correlated in their vital rates (growth, death, etc.) from year to year. It is very common for populations, whether they be bacteria, plants, or humans, to be temporally autocorrelated. This poses a challenge for stochastic population modeling, because a temporally correlated population will behave differently from an uncorrelated one. This package provides tools for simulating populations with white noise (no temporal autocorrelation), red noise (positive temporal autocorrelation), and blue noise (negative temporal autocorrelation). The algebraic formulation for autocorrelated noise comes from Ruokolainen et al. (2009) \doi{10.1016/j.tree.2009.04.009}. Models for unstructured populations and for structured populations (matrix models) are available.

Simulate Temporally Autocorrelated Populations
}
\details{
See the README on \href{https://github.com/japilo/colorednoise#readme}{GitHub}
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/japilo/colorednoise/issues}
}

}
\author{
\strong{Maintainer}: July Pilowsky \email{pilowskyj@caryinstitute.org} (\href{https://orcid.org/0000-0002-6376-2585}{ORCID})

}
\keyword{internal}
