% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/juxtapose.R
\name{juxtapose}
\alias{juxtapose}
\title{Compare Images}
\usage{
juxtapose(
  response,
  type = c("side-by-side", "stacked", "c-focus", "h-focus", "v-focus", "h-split",
    "v-split", "d-split", "u-animate", "s-animate"),
  pane = c("plot", "view", "none")
)
}
\arguments{
\item{response}{a response object of a \code{colorize} function call.}

\item{type}{defines the type of juxtaposition: \itemize{
\item \code{side-by-side} original image left, colorized right.
\item \code{stacked} original above colorized.
\item \code{c-focus} colorized center with original image border.
\item \code{h-focus} above and below strips of original image.
\item \code{v-focus} left and right strips of original image.
\item \code{h-split} horizontally halved.
\item \code{v-split} vertically halved.
\item \code{d-split} diagonally halved.
\item \code{u-animate} animated, colorized to the top (upwards).
\item \code{s-animate} animated, colorized from left to right (sideways).
 }}

\item{pane}{defines in which pane the image is displayed: \code{Plots} or \code{Viewer}.}
}
\value{
The function adds the comparison to the response object and returns it invisibly.
}
\description{
\code{juxtapose} compares the original image with the colorized version obtained with
    \code{colorize}.
}
\examples{
\dontrun{
# Compare images
res <- colorize(img = "https://upload.wikimedia.org/wikipedia/commons/9/9e/Breadfruit.jpg")
juxtapose(res)
}
}
