% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keener.R
\name{keener}
\alias{keener}
\alias{rate_keener}
\alias{rank_keener}
\alias{skew_keener}
\alias{normalize_keener}
\title{Keener method}
\usage{
rate_keener(cr_data, ..., fill = 0, force_nonneg_h2h = TRUE,
  skew_fun = skew_keener, normalize_fun = normalize_keener, eps = 0.001)

rank_keener(cr_data, ..., fill = 0, force_nonneg_h2h = TRUE,
  skew_fun = skew_keener, normalize_fun = normalize_keener, eps = 0.001,
  keep_rating = FALSE, ties = c("average", "first", "last", "random", "max",
  "min"), round_digits = 7)

skew_keener(x)

normalize_keener(mat, cr_data)
}
\arguments{
\item{cr_data}{Competition results in format ready for
\link[comperes:as_longcr]{as_longcr()}.}

\item{...}{Head-to-Head expression (see \link[comperes:h2h_mat]{h2h_mat()}).}

\item{fill}{A single value to use instead of NA for missing pairs.}

\item{force_nonneg_h2h}{Whether to force nonnegative values in Head-to-Head
matrix.}

\item{skew_fun}{Skew function.}

\item{normalize_fun}{Normalization function.}

\item{eps}{Coefficient for forcing irreducibility.}

\item{keep_rating}{Whether to keep rating column in ranking output.}

\item{ties}{Value for \code{ties} in \code{\link[=round_rank]{round_rank()}}.}

\item{round_digits}{Value for \code{round_digits} in \code{\link[=round_rank]{round_rank()}}.}

\item{x}{Argument for \code{skew_keener()}.}

\item{mat}{Argument for \code{normalize_keener()}.}
}
\value{
\code{rate_keener()} returns a \link[tibble:tibble]{tibble} with columns
\code{player} (player identifier) and \code{rating_keener} (Keener
\link[=rating-ranking]{rating}). Sum of all ratings should be equal to 1. \strong{Bigger
value indicates better player performance}.

\code{rank_keener()} returns a \code{tibble} with columns \code{player}, \code{rating_keener} (if
\code{keep_rating = TRUE}) and \code{ranking_keener} (Keener \link[=rating-ranking]{ranking}
computed with \code{\link[=round_rank]{round_rank()}}).

\code{skew_keener()} returns skewed vector of the same length as \code{x}.

\code{normalize_keener()} returns normalized matrix with the same dimensions as
\code{mat}.
}
\description{
Functions to compute \link[=rating-ranking]{rating} and \link[=rating-ranking]{ranking}
using Keener method.
}
\details{
Keener rating method is based on Head-to-Head matrix of the
competition results. Therefore it can be used for competitions with
variable number of players. Its algorithm is as follows:
\enumerate{
\item Compute Head-to-Head matrix of competition results based on Head-to-Head
expression supplied in \code{...} (see \link[comperes:h2h_mat]{h2h_mat()} for
technical details and section \strong{Design of Head-to-Head values} for design
details). Head-to-Head values are computed based only on the games between
players of interest (see Players). Ensure that there are no \code{NA}s by using
\code{fill} argument. If \code{force_nonneg_h2h} is \code{TRUE} then the minimum value is
subtracted (in case some Head-to-Head value is strictly negative).
\item Update raw Head-to-Head values (denoted as S) with the pair-normalization:
a_{ij} = (S_ij + 1) / (S_ij + S_ji + 2). This step should make comparing
different players more reasonable.
\item Skew Head-to-Head values with applying \code{skew_fun} to them. \code{skew_fun}
should take numeric vector as only argument. It should return skewed vector.
The default skew function is \code{skew_keener()}. This step should make abnormal
results not very abnormal. To omit this step supply \code{skew_fun = NULL}.
\item Normalize Head-to-Head values with \code{normalize_fun} using \code{cr_data}.
\code{normalize_fun} should take Head-to-Head matrix as the first argument and
\code{cr_data} as second. It should return normalized matrix. The default
normalization is \code{normalize_keener()} which divides Head-to-Head value of
'player1'-'player2' matchup divided by the number of games played by
'player1' (error is thrown if there are no games). This step should take into
account possibly not equal number of games played by players. To omit this
step supply \code{normalize_keener = NULL}.
\item Add small value to Head-to-Head matrix to ensure its irreducibility. If
all values are strictly positive then this step is omitted. In other case
small value is computed as the smallest non-zero Head-to-Head value
multiplied by \code{eps}. This step is done to ensure applicability of
Perron-Frobenius theorem.
\item Compute Perron-Frobenius vector of the resultant matrix, i.e. the strictly
positive real eigenvector (which values sum to 1) for eigenvalue (which is
real) of the maximum absolute value. This vector is Keener rating vector.
}

If using \code{normalize_keener()} in normalization step, ensure to analyze
players which actually played games (as division by a number of played games
is made). If some player didn't play any game, en error is thrown.
}
\section{Design of Head-to-Head values}{


Head-to-Head values in these functions are assumed to follow the property
which can be \emph{equivalently} described in two ways:
\itemize{
\item In terms of \link[comperes:h2h_mat]{matrix format}: \strong{the more Head-to-Head
value in row \emph{i} and column \emph{j} the better player from row \emph{i} performed than
player from column \emph{j}}.
\item In terms of \link[comperes:h2h_long]{long format}: \strong{the more Head-to-Head
value the better player1 performed than player2}.
}

This design is chosen because in most competitions the goal is to score
\strong{more points} and not less. Also it allows for more smooth use of
\link[comperes:h2h_funs]{h2h_funs} from \code{comperes} package.
}

\section{Players}{


\code{comperank} offers a possibility to handle certain set of players. It is done
by having \code{player} column (in \link[comperes:as_longcr]{longcr} format) as factor
with levels specifying all players of interest. In case of factor the result
is returned only for players from its levels. Otherwise - for all present
players.
}

\examples{
rate_keener(ncaa2005, sum(score1))

rank_keener(ncaa2005, sum(score1))

rank_keener(ncaa2005, sum(score1), keep_rating = TRUE)

# Impact of skewing
rate_keener(ncaa2005, sum(score1), skew_fun = NULL)

# Impact of normalization.
rate_keener(ncaa2005[-(1:2), ], sum(score1))

rate_keener(ncaa2005[-(1:2), ], sum(score1), normalize_fun = NULL)

}
\references{
James P. Keener (1993) \emph{The Perron-Frobenius theorem and the
ranking of football teams}. SIAM Review, 35(1):80–93, 1993.
}
