% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.output.R
\name{compare.two.runs}
\alias{compare.two.runs}
\title{Compare two conStruct runs}
\usage{
compare.two.runs(
  conStruct.results1,
  data.block1,
  conStruct.results2,
  data.block2,
  prefix,
  layer.colors = NULL
)
}
\arguments{
\item{conStruct.results1}{The list output by a 
\code{conStruct} run.}

\item{data.block1}{A \code{data.block} list saved during a 
\code{conStruct} run.}

\item{conStruct.results2}{The list output by a second
\code{conStruct} run.}

\item{data.block2}{A \code{data.block} list saved during a 
second \code{conStruct} run.}

\item{prefix}{A character vector to be prepended to all figures.}

\item{layer.colors}{A \code{vector} of colors to be used in 
plotting results for different layers. Users must 
specify one color per layer.  If \code{NULL}, plots 
will use a pre-specified vector of colors.}
}
\value{
This function has only invisible return values.
}
\description{
\code{compare.two.runs} makes figures comparing the output 
	from two conStruct analyses.
}
\details{
This function takes the outputs from two conStruct analyses and 
generates a number of plots for comparing results and 
diagnosing MCMC performance.

This function produces a variety of plots that can be 
useful for comparing results from two \code{conStruct} analyses.
 The runs must have the same number of independent MCMC chains, 
	but may have different values of \code{K}. The spatial and 
nonspatial models can be compared. If the runs were executed 
with different values of \code{K}, the run with the smaller 
value of \code{K} should be specified in the first set of 
arguments (\code{conStruct.results1} and \code{data.block1}).

 The plots made are by no means an exhaustive, and users are 
	encouraged to make further plots, or customize these plots as they 
see fit.  For each plot, one file is generated for each MCMC chain 
in each analysis (specified with the \code{n.chains} argument in 
the function \code{conStruct}. For clarity, the layers in the second 
	are matched to those in the first using the function 
\code{match.clusters.x.runs} The plots generated (as .pdf files) are:
\itemize{
	\item Structure plot - STRUCTURE-style plot, where each sample 
		is represented as a stacked bar plot, and the length of the 
		bar plot segments of each color represent that sample's 
		admixture proportion in that layer. Described further 
		in the help page for \code{make.structure.plot}.
	\item Admixture pie plot - A map of samples in which each sample's 
			location is denoted with a pie chart, and the proportion 
			of a pie chart of each color represents that sample's 
			admixture in each layer. Described further in the help 
			page for \code{make.admix.pie.plot}
	\item model.fit.CIs - A plot of the sample allelic covariance 
		shown with the 95\% credible interval of the parametric 
		covariance for each entry in the matrix.
	\item layer.covariances - A plot of the layer-specific 
			covariances overlain unto the sample allelic covariance.
	\item Trace plots - Plots of parameter values over the MCMC.
	\itemize{
		\item lpd - A plot of the log posterior probability over the MCMC.
		\item nuggets - A plot of estimates of the nugget parameters 
			over the MCMC.
		\item gamma - A plot of estimates of the gamma parameter 
			over the MCMC.
		\item layer.cov.params - Plots of estimates of the 
			layer-specific parameters over the MCMC.
		\item admix.props - A plot of estimates of the admixture proportions 
			over the MCMC.
	}
}
}
