% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concord_hs_sitc.R
\name{concord_hs_sitc}
\alias{concord_hs_sitc}
\title{Converting HS and SITC Codes}
\source{
Concordance tables provided by:
\itemize{
  \item World Integrated Trade Solution (WITS), World Bank <https://wits.worldbank.org/product_concordance.html>
  \item United Nations Trade Statistics <https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp>
}
}
\usage{
concord_hs_sitc(sourcevar, origin, destination, dest.digit = 4, all = FALSE)
}
\arguments{
\item{sourcevar}{An input character vector of HS or SITC codes. The function accepts 2, 4, 6-digit codes for HS and 1 to 5-digit codes for SITC.}

\item{origin}{A string setting the input industry classification: "HS" (combined), "HS0" (1988/92), "HS1" (1996), "HS2" (2002), "HS3" (2007), "HS4" (2012), "HS5" (2017), "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), and "SITC4" (2006).}

\item{destination}{A string setting the output industry classification: "HS" (combined), "HS0" (1988/92), "HS1" (1996), "HS2" (2002), "HS3" (2007), "HS4" (2012), "HS5" (2017), "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006).}

\item{dest.digit}{An integer indicating the preferred number of digits for output codes. Allows 2, 4, or 6 digits for HS codes and 1 to 5 digits for SITC codes. The default is 4 digits.}

\item{all}{Either TRUE or FALSE. If TRUE, the function will return (1) all matched outputs for each input, and (2) the share of occurrences for each matched output among all matched outputs. Users can use the shares as weights for more precise concordances. If FALSE, the function will only return the matched output with the largest share of occurrences (the mode match). If the mode consists of multiple matches, the function will return the first matched output.}
}
\value{
The matched output(s) for each element of the input vector. Either a list object when all = TRUE or a character vector when all = FALSE.
}
\description{
Concords Harmonized System codes (HS0, HS1, HS2, HS3, HS4, HS5, HS combined) to and from Standard International Trade Classification codes (SITC Revision 1, 2, 3, 4).
}
\note{
Always include leading zeros in codes (e.g. use HS code 010110 instead of 10110)---results may be buggy otherwise.
}
\examples{
## HS combined to SITC4
# one input: one-to-one match
concord_hs_sitc(sourcevar = "120600",
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = FALSE)

concord_hs_sitc(sourcevar = "120600",
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = TRUE)

# two inputs: multiple-to-one match
concord_hs_sitc(sourcevar = c("010110", "010119"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = FALSE)

concord_hs_sitc(sourcevar = c("010110", "010119"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = TRUE)

# two inputs: repeated
concord_hs_sitc(sourcevar = c("120600", "120600"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = FALSE)

# one to multiple matches
concord_hs_sitc(sourcevar = c("1206", "1001"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = TRUE)

# if no match, will return NA and give warning message
concord_hs_sitc(sourcevar = c("120600", "120610"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = FALSE)

# 4-digit inputs, 5-digit outputs
concord_hs_sitc(sourcevar = c("1206", "8546"),
                origin = "HS", destination = "SITC4",
                dest.digit = 5, all = TRUE)

# 6-digit inputs, 3-digit outputs
concord_hs_sitc(sourcevar = c("120600", "854610"),
                origin = "HS", destination = "SITC4",
                dest.digit = 3, all = TRUE)

## SITC4 to HS combined
concord_hs_sitc(sourcevar = c("22240", "77322"),
                origin = "SITC4", destination = "HS",
                dest.digit = 6, all = FALSE)
}
