% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msplit.R
\name{conformal.fun.msplit}
\alias{conformal.fun.msplit}
\title{Functional Multi Split Conformal Prediction Regions}
\usage{
conformal.fun.msplit(
  x,
  t_x,
  y,
  t_y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed.rand = FALSE,
  verbose = FALSE,
  rho = NULL,
  s.type = "alpha-max",
  B = 50,
  lambda = 0,
  tau = 0.08
)
}
\arguments{
\item{x}{The input variable, a list of n elements. Each element is composed by a list
of p vectors(with variable length, since the evaluation grid may change).
If x is NULL, the function will sample it from a gaussian.}

\item{t_x}{The grid points for the evaluation of function x. It is a list of vectors.
If the x data type is "fData" or "mfData" is must be NULL.}

\item{y}{The response variable. It is either, as with x, a list of list of
vectors or an fda object (of type fd, fData, mfData).}

\item{t_y}{The grid points for the evaluation of function y_val. It is a list of vectors.
If the y_val data type is "fData" or "mfData" is must be NULL.}

\item{x0}{The new points to evaluate, a list of n0 elements. Each element is composed
by a list of p vectors(with variable length).}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: list of features,
and y: list of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{split}{Indices that define the data-split to be used (i.e., the indices
define the first half of the data-split, on which the model is trained).
Default is NULL, in which case the split is chosen randomly.}

\item{seed}{Integer to be passed to set.seed before defining the random
data-split to be used. Default is FALSE, which effectively sets no seed.
If both split and seed are passed, the former takes priority and the latter
is ignored.}

\item{randomized}{Should the randomized approach be used? Default is FALSE.}

\item{seed.rand}{The seed for the randomized version of the conformal.split.fun.
Default is FALSE.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}

\item{rho}{Vector containing the split proportion between
training and calibration set.
It has B components. Default is 0.5.}

\item{s.type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev","alpha-max".}

\item{B}{Number of repetitions. Default is 100.}

\item{lambda}{Smoothing parameter. Default is 0.}

\item{tau}{It is a smoothing parameter:
tau=1-1/B  Bonferroni intersection method
tau=0 unadjusted intersection
Default is 0.05, a value selected through sensitivity analysis .}
}
\value{
A list containing lo, up, tn. lo and up are lists of length n0,
containing lists of length p, with vectors of lower and upper bounds.
tn is the list of the grid evaluations.
}
\description{
Compute prediction regions using functional multi split conformal inference.
}
\details{
The work is an extension of the univariate approach to Multi Split
conformal inference to a multivariate functional context, exploiting the concept of
depth measures.

This function is based on the package future.apply to
 perform parallelisation. If this package is not installed, then the function
 will abort.
}
\examples{
library(roahd)

N = 10
P= 5
grid = seq( 0, 1, length.out = P )
C = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )
values = generate_gauss_fdata( N,
                                      centerline = sin( 2 * pi * grid ),
                                      Cov = C )
fD = fData( grid, values )
x0=list(as.list(grid))
fun=mean_lists()
rrr<-conformal.fun.msplit(x=NULL,t_x=NULL, y=fD,t_y=NULL, x0=list(x0[[1]]),
                          fun$train.fun, fun$predict.fun,alpha=0.2,
                          split=NULL, seed=FALSE, randomized=FALSE,seed.rand=FALSE,
                          verbose=FALSE, rho=NULL,B=2,lambda=0)


}
\references{
"Multi Split Conformal Prediction" by Solari, Djordjilovic (2021) is
the baseline for the univariate case.
}
