% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R
\name{create_directory_cnt}
\alias{create_directory_cnt}
\alias{create_directory_cnt.ConnectorFS}
\title{Create a directory}
\usage{
create_directory_cnt(connector_object, name, open = TRUE, ...)

\method{create_directory_cnt}{ConnectorFS}(connector_object, name, open = TRUE, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{name}{\link{character} The name of the directory to create}

\item{open}{\link{logical} Open the directory as a new connector object.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to create a directory for a connector.
Mostly relevant for file storage connectors.

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:create]{fs::dir_create()}} to create a directory at the path of the connector.
}
}
\examples{
# Create a directory in a file storage

folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connector_fs(folder)

cnt |>
  list_content_cnt(pattern = "new_folder")

cnt |>
  create_directory_cnt("new_folder")

# This will return new connector object of a newly created folder
new_connector <- cnt |>
  list_content_cnt(pattern = "new_folder")

cnt |>
  remove_directory_cnt("new_folder")

}
