% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condinep.R
\name{checkCI}
\alias{checkCI}
\alias{checkCI.array}
\alias{checkCI.tables}
\title{Check conditional independence}
\usage{
checkCI(x, A, B, C = integer(0), eps = .Machine$double.eps, ...)

\method{checkCI}{array}(x, A, B, C = integer(0), eps = .Machine$double.eps, ...)

\method{checkCI}{tables}(x, A, B, C = integer(0), eps = .Machine$double.eps, ...)
}
\arguments{
\item{x}{an array or object of class \code{tables}}

\item{A, B}{the sets of variables whose independence is to be tested}

\item{C}{conditioning set (possibly empty)}

\item{eps}{tolerance parameter}

\item{...}{other arguments to methods}
}
\value{
A logical, or a vector of logicals of the same length as the number
of tables provided, indicating whether the conditional independence seems 
to hold numerically.
}
\description{
Gives a numerical check that a (conditional) independence holds in a probability distribution.
}
\details{
just tests to an appropriate numerical precision that a conditional independence
holds: this is *not* a statistical test for conditional independence.
If \code{A} and \code{B} overlap with \code{C} then these vertices are ignored.  If \code{A}
and \code{B} intersect with one another (but not \code{C}) then the solution is always
false.
}
\section{Methods (by class)}{
\itemize{
\item \code{array}: method for \code{array} object

\item \code{tables}: method for \code{tables} object
}}

