% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_indicator_EUF.R
\name{extract_indicator_EUF}
\alias{extract_indicator_EUF}
\title{Create a dataset (tibble) for an indicator.}
\usage{
extract_indicator_EUF(
  indicator_code,
  fromTime,
  toTime,
  gender = c("Total", "Females", "Males")[1],
  countries = convergEU_glb()$EU27$memberStates$codeMS
)
}
\arguments{
\item{indicator_code}{the variable describing countries}

\item{fromTime}{first year to be considered}

\item{toTime}{last year to be considered}

\item{gender}{which gender, one of  c("Total","Females","Males")}

\item{countries}{a collection of strings representing countries
in the standard two letters format}
}
\value{
a dataset (tibble) years by countries, possibly conditioned to gender
}
\description{
From the Eurofound database, a dataset is created whose structure is
years by countries, possibly conditioned to  gender.
}
\examples{


# Extract indicator labelled "lifesatisf" and accessible from "dbEUF2018meta" data:
print(dbEUF2018meta, n=20, width=100)
dbEUF2018meta$Code_in_database
myTB1 <- extract_indicator_EUF(
    indicator_code = "lifesatisf", #Code_in_database
    fromTime=2003,
    toTime=2015,
    gender= c("Total","Females","Males")[1])

# Extract indicator "exposdiscr_p" (Code_in_database) from 2003 to 2016:
myTB2 <- extract_indicator_EUF(
    indicator_code = "exposdiscr_p", #Code_in_database
    fromTime=2003,
    toTime=2016,
    gender= c("Total","Females","Males")[1])

# Extract indicator "lifesatisf" from 1998 to 2016 for females:
myTB3 <- extract_indicator_EUF(
    indicator_code = "lifesatisf", #Code_in_database
    fromTime = 1998,
    toTime = 2016,
    gender = c("Total","Females","Males")[2])

# Extract indicator "lifesatisf" from 1960 to 2016 for males of EU12:
myTB4 <- extract_indicator_EUF(
    indicator_code = "lifesatisf", #Code_in_database
    fromTime=1960,
    toTime=2016,
   gender= c("Total","Females","Males")[3],
   countries= convergEU_glb()$EU12$memberStates$codeMS)


}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
