% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userattributes.R
\name{userattributes}
\alias{userattributes}
\title{Retrieve Custom Object Attributes}
\usage{
userattributes(obj)
}
\arguments{
\item{obj}{R object whose custom attributes to extract.}
}
\value{
Named list of custom attributes, mimicking the output of the base function \code{\link{attributes}}, but only including custom attributes
}
\description{
This function takes a generic R object and returns the custom attributes
added by the user, distinguishing them from the object's inherent attributes.
}
\examples{
# Create a list containing objects of different classes
example = list(1,
               as.integer(1:3),
               bit64::as.integer64(1),
               diag(5),
               array(0,c(2,3,5)),
               list(a=1,b='c'),
               data.frame(x=1, y=1:10, char=LETTERS[1:10])
)

# Loop over all the objects to check if the custom attribute is correctly extracted.
for (i in seq_along(example)) {
  x = example[[i]]
  attr(x,'MyAttribute') = 'Test'
    cat(sprintf('Class = \%s, Custom attribute(s) = \%s\n',class(x)[1],
                paste(names(userattributes(x)), collapse = ', ')))
}
}
\seealso{
\code{attributes}
}
