% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_collection.R
\name{set_collection}
\alias{set_collection}
\title{Set, create or modify columns with museum- or collection-specific information}
\usage{
set_collection(
  .df,
  datasetID = NULL,
  datasetName = NULL,
  catalogNumber = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{datasetID}{An identifier for the set of data. May be a global unique
identifier or an identifier specific to a collection or institution.}

\item{datasetName}{The name identifying the data set from which the record
was derived.}

\item{catalogNumber}{A unique identifier for the record within the data set
or collection.}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A \code{tibble} with the requested fields added/reformatted.
}
\description{
Format fields that specify the collection or catalog number of a
specimen or occurrence record to a \code{tibble} using Darwin Core Standard.

In practice this is no different from using \code{mutate()}, but gives some
informative errors, and serves as a useful lookup for fields in
the Darwin Core Standard.
}
\details{
Examples of \code{datasetID} values:
\itemize{
\item \verb{b15d4952-7d20-46f1-8a3e-556a512b04c5}
}

Examples of \code{datasetName} values:
\itemize{
\item \verb{Grinnell Resurvey Mammals}
\item \verb{Lacey Ctenomys Recaptures}
}

Examples of \code{catalogNumber} values:
\itemize{
\item \code{145732}
\item \verb{145732a}
\item \code{2008.1334}
\item \code{R-4313}
}
}
\examples{
df <- tibble::tibble(
  name = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14"),
  catalog_num = c("16789a", "16789c", "08742f"),
  dataset = c("Frog search", "Frog search", "Frog search")
  )

# Reformat columns to Darwin Core terms
df |>
  set_collection(
    catalogNumber = catalog_num,
    datasetName = dataset
    )

}
