% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrCircle.R
\name{corrCircle}
\alias{corrCircle}
\title{corrCircle}
\usage{
corrCircle(mat, threshold = 0, ticks = FALSE)
}
\arguments{
\item{mat}{A square correlation matrix to visualise.}

\item{threshold}{A numeric value indicating the minimum absolute correlation
value to display in the plot.}

\item{ticks}{A logical value indicating whether to display ticks (TRUE) or not (FALSE),
default is FALSE.}
}
\value{
A circular chord plot object displaying the correlations between variables.
}
\description{
This function creates a circular plot of correlations between variables in a dataset.
}
\details{
When using a large amount of data, this plot can quickly become over
complicated. It is recommended to filter the correlations using the \code{threshold}
argument to simplify the visualisation.
}
\examples{
cm <- cor(mtcars)

corrCircle(mat = cm,
          threshold = 0.8)


}
