% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{plot_gsea2}
\alias{plot_gsea2}
\title{Plot 2-way GSEA results}
\usage{
plot_gsea2(
  gsea.obj,
  twoColors = c("red", "blue"),
  plotNames = FALSE,
  title = "Running Enrichment Score",
  bottomTitle = "List Values",
  bottomYlabel = "Signature values",
  legside1 = NULL,
  legside2 = NULL
)
}
\arguments{
\item{gsea.obj}{GSEA object produced by the \code{gsea} function}

\item{twoColors}{the two colors to use for positive[1] and negative[2]
enrichment scores, and of the barcodes}

\item{plotNames}{Logical. Should the set names be plotted?}

\item{title}{String to be plotted above the Running Enrichment Score}

\item{bottomTitle}{String for the title of the bottom part of the plot}

\item{bottomYlabel}{String for the Y label of the bottom plot
(FALSE by default)}

\item{legside1}{String specifying the position of the first NES legend,
for example "topright", "bottomleft". Default is NULL, letting the function
automatically place it}

\item{legside2}{String specifying the position of the second NES legend,
for example "topright", "bottomleft". Default is NULL, letting the function
automatically place it}
}
\value{
Nothing, a plot is generated in the default output device
}
\description{
This function generates a GSEA plot from a gsea object
}
\examples{
reflist<-setNames(-sort(rnorm(1000)),paste0('gene',1:1000))
set1<-paste0('gene',sample(1:200,50))
set2<-paste0('gene',sample(801:1000,50))
obj<-gsea2(reflist,set1,set2,method='pareto',np=1000)
plot_gsea2(obj)
}
